/*
 * @(#) $(JCGO)/include/jcgovcls.c --
 * a part of the JCGO runtime subsystem.
 **
 * Project: JCGO (http://www.ivmaisoft.com/jcgo/)
 * Copyright (C) 2001-2012 Ivan Maidanski <ivmai@ivmaisoft.com>
 * All rights reserved.
 */

/**
 * This file is compiled together with the files produced by the JCGO
 * translator (do not include and/or compile this file directly).
 */

/*
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 **
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License (GPL) for more details.
 **
 * Linking this library statically or dynamically with other modules is
 * making a combined work based on this library. Thus, the terms and
 * conditions of the GNU General Public License cover the whole
 * combination.
 **
 * As a special exception, the copyright holders of this library give you
 * permission to link this library with independent modules to produce an
 * executable, regardless of the license terms of these independent
 * modules, and to copy and distribute the resulting executable under
 * terms of your choice, provided that you also meet, for each linked
 * independent module, the terms and conditions of the license of that
 * module. An independent module is a module which is not derived from
 * or based on this library. If you modify this library, you may extend
 * this exception to your version of the library, but you are not
 * obligated to do so. If you do not wish to do so, delete this
 * exception statement from your version.
 */

#ifdef JCGO_VER

JCGO_NOSEP_STATIC java_lang_String CFASTCALL
java_lang_VMClass__getClassSignature__Lc( java_lang_Class klass )
{
 /* not implemented */
 return jnull;
}

JCGO_NOSEP_STATIC jint CFASTCALL
java_lang_VMClass__initialize0__Lc( java_lang_Class klass )
{
#ifdef JCGO_STDCLINIT
 jcgo_clinitTrig(klass);
#else
#ifdef JCGO_CLINITCHK
 jcgo_clinitCheckOrder(klass);
#endif
#endif
 return 0;
}

JCGO_NOSEP_STATIC java_lang_Object CFASTCALL
java_lang_VMClass__getClassLoader0__Lc( java_lang_Class klass )
{
#ifdef OBJT_java_lang_ClassLoader_StaticData
 JCGO_CLINIT_TRIG(java_lang_ClassLoader_StaticData__class);
 return
  (java_lang_Object)java_lang_ClassLoader_StaticData__class.systemClassLoader;
#else
 return jnull;
#endif
}

JCGO_NOSEP_STATIC void CFASTCALL
java_lang_VMClass__throwException0__Lo( java_lang_Object throwable )
{
 JCGO_THROW_EXC(throwable);
}

JCGO_NOSEP_STATIC java_lang_Object CFASTCALL
java_lang_VMClass__vmdataForObjArray0__I( jint dims )
{
 return JCGO_EXPECT_TRUE((unsigned)dims - (unsigned)1 <
         (unsigned)JCGO_DIMS_MAX) ? (java_lang_Object)&JCGO_METHODS_OF(
         jcgo_objArrStubClasses[(int)dims - 1].vmdata) : jnull;
}

JCGO_NOSEP_STATIC java_lang_Class CFASTCALL
java_lang_VMClass__getSourceHeadClass0__Lc( java_lang_Class klass )
{
 /* implemented correctly only for source files containing one class */
 return klass;
}

#endif
